/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.impl.IPCResponseFactory;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.OSPFv6DBDescriptionPacket;
import com.cisco.pt.ipc.sim.pdu.OSPFv6LSAHeader;
import com.cisco.pt.ipc.sim.pdu.OSPFv6OptionField;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFv6PacketImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFv6DBDescriptionPacketImpl
extends OSPFv6PacketImpl
implements OSPFv6DBDescriptionPacket {
    protected Short interfaceMTU;
    protected OSPFv6OptionField option;
    protected boolean IBit;
    protected boolean MBit;
    protected boolean MSBit;
    protected int DDSequenceNumber;
    protected List<OSPFv6LSAHeader> lsaHeaders;

    public OSPFv6DBDescriptionPacketImpl() {
        this.fieldNames.add("OSPFv6DBDescriptionPacketImpl_interfaceMTU");
        this.fieldNames.add("OSPFv6DBDescriptionPacketImpl_option");
        this.fieldNames.add("OSPFv6DBDescriptionPacketImpl_IBit");
        this.fieldNames.add("OSPFv6DBDescriptionPacketImpl_MBit");
        this.fieldNames.add("OSPFv6DBDescriptionPacketImpl_MSBit");
        this.fieldNames.add("OSPFv6DBDescriptionPacketImpl_DDSequenceNumber");
        this.fieldNames.add("OSPFv6DBDescriptionPacketImpl_lsaHeaders");
        this.signalType = "Ospfv6DBDescriptionPacket";
    }

    @Override
    public Short getInterfaceMTU() {
        return this.interfaceMTU;
    }

    @Override
    public void setInterfaceMTU(Short interfaceMTU) {
        this.interfaceMTU = interfaceMTU;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6DBDescriptionPacketImpl_interfaceMTU")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("OSPFv6DBDescriptionPacketImpl_interfaceMTU", interfaceMTU));
            return;
        }
    }

    @Override
    public OSPFv6OptionField getOption() {
        return this.option;
    }

    @Override
    public void setOption(OSPFv6OptionField option) {
        this.option = option;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6DBDescriptionPacketImpl_option")) continue;
            this.fieldTable.set(i, new Pair<String, OSPFv6OptionField>("OSPFv6DBDescriptionPacketImpl_option", option));
            return;
        }
    }

    @Override
    public boolean getIBit() {
        return this.IBit;
    }

    @Override
    public void setIBit(boolean IBit) {
        this.IBit = IBit;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6DBDescriptionPacketImpl_IBit")) continue;
            this.fieldTable.set(i, new Pair<String, Boolean>("OSPFv6DBDescriptionPacketImpl_IBit", IBit));
            return;
        }
    }

    @Override
    public boolean getMBit() {
        return this.MBit;
    }

    @Override
    public void setMBit(boolean MBit) {
        this.MBit = MBit;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6DBDescriptionPacketImpl_MBit")) continue;
            this.fieldTable.set(i, new Pair<String, Boolean>("OSPFv6DBDescriptionPacketImpl_MBit", MBit));
            return;
        }
    }

    @Override
    public boolean getMSBit() {
        return this.MSBit;
    }

    @Override
    public void setMSBit(boolean MSBit) {
        this.MSBit = MSBit;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6DBDescriptionPacketImpl_MSBit")) continue;
            this.fieldTable.set(i, new Pair<String, Boolean>("OSPFv6DBDescriptionPacketImpl_MSBit", MSBit));
            return;
        }
    }

    @Override
    public int getDDSequenceNumber() {
        return this.DDSequenceNumber;
    }

    @Override
    public void setDDSequenceNumber(int DDSequenceNumber) {
        this.DDSequenceNumber = DDSequenceNumber;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6DBDescriptionPacketImpl_DDSequenceNumber")) continue;
            this.fieldTable.set(i, new Pair<String, Integer>("OSPFv6DBDescriptionPacketImpl_DDSequenceNumber", DDSequenceNumber));
            return;
        }
    }

    @Override
    public List<OSPFv6LSAHeader> getLsaHeaders() {
        return this.lsaHeaders;
    }

    @Override
    public void setLsaHeaders(List<OSPFv6LSAHeader> lsaHeaders) {
        this.lsaHeaders = lsaHeaders;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("OSPFv6DBDescriptionPacketImpl_lsaHeaders")) continue;
            this.fieldTable.set(i, new Pair<String, List<OSPFv6LSAHeader>>("OSPFv6DBDescriptionPacketImpl_lsaHeaders", lsaHeaders));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("OSPFv6DBDescriptionPacketImpl_interfaceMTU")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("OSPFv6DBDescriptionPacketImpl_option")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("OSPFv6DBDescriptionPacketImpl_IBit")) {
            return PtmpTypeValue.BOOL;
        }
        if (fieldName.equals("OSPFv6DBDescriptionPacketImpl_MBit")) {
            return PtmpTypeValue.BOOL;
        }
        if (fieldName.equals("OSPFv6DBDescriptionPacketImpl_MSBit")) {
            return PtmpTypeValue.BOOL;
        }
        if (fieldName.equals("OSPFv6DBDescriptionPacketImpl_DDSequenceNumber")) {
            return PtmpTypeValue.INT;
        }
        if (fieldName.equals("OSPFv6DBDescriptionPacketImpl_lsaHeaders")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Short>("OSPFv6DBDescriptionPacketImpl_interfaceMTU", this.interfaceMTU));
        this.fieldTable.add(new Pair<String, OSPFv6OptionField>("OSPFv6DBDescriptionPacketImpl_option", this.option));
        this.fieldTable.add(new Pair<String, Boolean>("OSPFv6DBDescriptionPacketImpl_IBit", this.IBit));
        this.fieldTable.add(new Pair<String, Boolean>("OSPFv6DBDescriptionPacketImpl_MBit", this.MBit));
        this.fieldTable.add(new Pair<String, Boolean>("OSPFv6DBDescriptionPacketImpl_MSBit", this.MSBit));
        this.fieldTable.add(new Pair<String, Integer>("OSPFv6DBDescriptionPacketImpl_DDSequenceNumber", this.DDSequenceNumber));
        this.fieldTable.add(new Pair<String, List<OSPFv6LSAHeader>>("OSPFv6DBDescriptionPacketImpl_lsaHeaders", this.lsaHeaders));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.interfaceMTU = this.readShort(buffer);
        this.option = (OSPFv6OptionField)this.readIPCData(buffer);
        this.IBit = this.readBoolean(buffer);
        this.MBit = this.readBoolean(buffer);
        this.MSBit = this.readBoolean(buffer);
        this.DDSequenceNumber = this.readInt(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.lsaHeaders = new ArrayList<OSPFv6LSAHeader>();
        for (Object o : tempList1) {
            this.lsaHeaders.add((OSPFv6LSAHeader)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.interfaceMTU = this.pduReadShort(buffer);
        this.option = (OSPFv6OptionField)IPCResponseFactory.getPDUData(buffer);
        this.IBit = this.pduReadBoolean(buffer);
        this.MBit = this.pduReadBoolean(buffer);
        this.MSBit = this.pduReadBoolean(buffer);
        this.DDSequenceNumber = this.pduReadInt(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)16);
        this.lsaHeaders = new ArrayList<OSPFv6LSAHeader>();
        for (Object o : tempList1) {
            this.lsaHeaders.add((OSPFv6LSAHeader)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putShort(this.interfaceMTU);
        if (this.option == null) {
            buffer.putString("");
        } else {
            this.option.encodeTypeAndPayload(buffer);
        }
        buffer.putBool(this.IBit);
        buffer.putBool(this.MBit);
        buffer.putBool(this.MSBit);
        buffer.putInt(this.DDSequenceNumber);
        buffer.putInt(this.lsaHeaders.size());
        for (OSPFv6LSAHeader item : this.lsaHeaders) {
            item.encodeTypeAndPayload(buffer);
        }
    }
}

